# KINGS: Learning Cyclicity-Regularized Coordination Graphs

This codebase is based on [PyMARL](https://github.com/oxwhirl/pymarl) and [SMAC](https://github.com/oxwhirl/smac) and contains the implementation
of **K**irchhoff **In**dex **G**uided **S**parsification for Deep Coordination Graphs (KINGS)

## Run an experiment 

Tasks in the MACO benchmark can be found in `src/envs`. To run an experiment on the MACO benchmark with KINGS enabled, in ```src``` directory do:

```shell
python main_gpu.py --config=dcg --env-config=hallway with sp_coeff=0.5 cyclicity_weighting=True sp_iters=3 rho_formulation=True
```
Notice that the code uses to ```sp_coeff``` to refer to lambda_sp and ```sp_iters```  to refer to the sparsification budget described in the paper.
To run DCG baseline, just set ```sp_coeff=0.0```, and for CASEC set nonzero ```sp_coeff``` and ```cyclicity_weighting=False```.  


To run experiments on the SMAC benchmark, with KINGS enabled, do:

```shell
python main_gpu.py --config=dcg --env-config=sc2 with env_args.map_name=1c3s5z sp_coeff=0.75 cyclicity_weighting=True sp_iters=2 rho_formulation=False use_action_repr=True
```
The config files act as defaults for an algorithm or environment. 
They are all located in `src/config`.
`--config` refers to the config files in `src/config/algs`.
`--env-config` refers to the config files in `src/config/envs`.
All results will be stored in the `Results` folder. The relevant performance metrics will be logged into
```info.json```

The values for ```sp_coeff``` (lambda_sp) and ```sp_iters``` (sparsification budget) to reproduce the MACO results can be found in the Tables (1) and (2), respectively.
For SMAC the values are: 
*  ```1c3s5z```: ```sp_coeff=0.75``` (KINGS & CASEC) and ```sp_iters=2``` (KINGS)
*  ```10m_vs_11m```: ```sp_coeff=0.65``` (KINGS & CASEC) and ```sp_iters=2``` (KINGS)


## Installation instructions

Install the pip environment:
```shell
python3 -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
pip install torch-scatter -f https://data.pyg.org/whl/torch-2.2.0+cu121.html
git clone https://github.com/oxwhirl/smac.git
pip install -e smac/
```

Set up StarCraft II and SMAC:
```shell
bash setup_sc.sh
```

This will download SC2 into the 3rdparty folder and copy the maps necessary to run over.

The requirements.txt file can be used to install the necessary packages into a virtual environment.

## Saving and loading learnt models

### Saving models

You can save the learnt models to disk by setting `save_model=True`, which is set to `False` by default. The frequency of saving models can be adjusted using `save_model_interval` configuration. Models will be saved in the result directory, under the folder named *models*. The directory corresponding to each run will contain models saved throughout the training process, each of which is named by the number of timesteps passed since the learning process starts.

### Loading models

Learnt models can be loaded using the `checkpoint_path` parameter, after which the learning will proceed from the corresponding timestep. 

## Watching StarCraft II replays

`save_replay` option allows saving replays of models which are loaded using `checkpoint_path`. Once the model is successfully loaded, `test_nepisode` number of episodes are run on the test mode and a .SC2Replay file is saved in the Replay directory of StarCraft II. Please make sure to use the episode runner if you wish to save a replay, i.e., `runner=episode`. The name of the saved replay file starts with the given `env_args.save_replay_prefix` (map_name if empty), followed by the current timestamp. 

The saved replays can be watched by double-clicking on them or using the following command:

```shell
python -m pysc2.bin.play --norender --rgb_minimap_size 0 --replay NAME.SC2Replay
```

**Note:** Replays cannot be watched using the Linux version of StarCraft II. Please use either the Mac or Windows version of the StarCraft II client.
