extra_labels = ["agent_0_obs_pos_x", "agent_0_obs_pos_y", "agent_1_obs_pos_x", "agent_1_obs_pos_y",
                "agent_0_obs_a1_pos_x", "agent_0_obs_a1_pos_y", "agent_1_obs_a0_pos_x", "agent_1_obs_a0_pos_y"]


def process(row_info):
    ret = {
        "agent_0_obs_pos_x": row_info["agent_0.pos_x"],
        "agent_0_obs_pos_y": row_info["agent_0.pos_y"],
        "agent_1_obs_pos_x": row_info["agent_1.pos_x"],
        "agent_1_obs_pos_y": row_info["agent_1.pos_y"],
    }

    manhattan_distance = abs(row_info["agent_0.pos_x"] - row_info["agent_1.pos_x"]) + abs(
        row_info["agent_0.pos_y"] - row_info["agent_1.pos_y"])

    if manhattan_distance > 2:
        ret["agent_0_obs_a1_pos_x"] = "UNK"
        ret["agent_0_obs_a1_pos_y"] = "UNK"
        ret["agent_1_obs_a0_pos_x"] = "UNK"
        ret["agent_1_obs_a0_pos_y"] = "UNK"
    else:
        ret["agent_0_obs_a1_pos_x"] = row_info["agent_1.pos_x"]
        ret["agent_0_obs_a1_pos_y"] = row_info["agent_1.pos_y"]
        ret["agent_1_obs_a0_pos_x"] = row_info["agent_0.pos_x"]
        ret["agent_1_obs_a0_pos_y"] = row_info["agent_0.pos_y"]

    return ret

def initial_cond(row_info):
    return True
