use serde::Serialize;

use crate::decentralization::sat_shield::AgentLabelActionTo;
use crate::shields::partial_obs_cent::AgentLabelHistory;

#[derive(Serialize)]
pub struct LabelAndSafeActions {
    pub label: AgentLabelHistory,
    pub actions: Vec<u32>
}

#[derive(Serialize)]
pub struct DecentralizedShield {
    pub history_len: u8,
    pub obs_names: Vec<Vec<String>>,
    pub safe_actions: Vec<Vec<LabelAndSafeActions>>,
}

impl DecentralizedShield {
    pub fn new(agent_label_actions: AgentLabelActionTo<bool>, obs_names: Vec<Vec<String>>, history_len: u8) -> Self{
        let safe_actions = agent_label_actions.into_iter().map(|label_actions| {
            label_actions.into_iter().map(|(label, action_bools)| {
                let action_idx = action_bools.into_iter().enumerate().filter_map(|(idx, action)| if action {Some(idx as u32)} else {None}).collect();
                LabelAndSafeActions {
                    label,
                    actions: action_idx
                }
            }).collect()
        }).collect();

        Self {
            history_len,
            safe_actions,
            obs_names
        }
    }
}