use crate::decentralization::max_perm_actions::{ActionNumber, Decentralization};
use crate::decentralization::sat_shield::{agent_label_map, AgentLabelActionTo, AgentLabelTo, get_labels_to_state_nums, get_possible_decentralizations, StateTo};
use crate::shields::PartialObsHistCentralizedShield;

pub fn safe_actions_in_all_decentralizations(agent_num: usize, dec_set: &StateTo<Decentralization>, state_nums: &Vec<u32>, action_size: ActionNumber) -> Vec<bool> {
    let mut actions = vec![true; action_size as usize];
    for sn in state_nums {
        let actions_in_state = &dec_set[sn][agent_num];
        for i in 0..(action_size) {
            if !actions_in_state.contains(&i) {
                actions[i as usize] = false;
            }
        }
    }

    actions
}

pub fn decentralization_set_to_shield(dec_set: &StateTo<Decentralization>, labels_to_state_nums: &AgentLabelTo<Vec<u32>>, action_spaces: &Vec<ActionNumber>) -> AgentLabelActionTo<bool>{
    agent_label_map(labels_to_state_nums, |agent_num, _label, state_nums|{
        safe_actions_in_all_decentralizations(agent_num, dec_set, state_nums, action_spaces[agent_num])
    })
}

pub fn check_dec_shield_fullness(shield: &AgentLabelActionTo<bool>) -> bool{
    shield.iter().all(|label_info| {
        label_info.iter().all(|(_, action_info)| action_info.contains(&true))
    })
}

pub fn find_decentralized_shield_arbitrary(centralized_shield: &PartialObsHistCentralizedShield, disable_fullness: bool) -> Option<AgentLabelActionTo<bool>> {
    /*
    Just choose any max-perm decentralization for each state; if there are any observations without legal actions, report failure
     */

    let labels_to_state_nums = get_labels_to_state_nums(centralized_shield);

    let decentralizations = get_possible_decentralizations(centralized_shield);
    let arbitrary_decentralization_set: StateTo<Decentralization> = decentralizations.into_iter().map(|(state, dec_at_state)| (state, dec_at_state[0].clone())).collect();

    let dec_shield: AgentLabelActionTo<bool> = decentralization_set_to_shield(&arbitrary_decentralization_set, &labels_to_state_nums, &centralized_shield.action_space);

    if disable_fullness || check_dec_shield_fullness(&dec_shield){
        Some(dec_shield)
    } else {
        None
    }
}
