use std::iter::zip;
use fnv::FnvHashSet;
use itertools::Itertools;
use kissat::{Solver, Var};
use crate::decentralization::sat_shield::{agent_label_map, AgentLabelActionTo, expand_available_actions, get_labels_to_state_nums, make_n_variables, sat_solution_to_shield_naive};
use crate::shields::PartialObsHistCentralizedShield;

pub fn find_decentralized_shield_sat_alt(centralized_shield: &PartialObsHistCentralizedShield) -> Option<AgentLabelActionTo<bool>> {

    let mut solver = Solver::new();

    let labels_to_state_nums = get_labels_to_state_nums(centralized_shield);

    let agent_label_action_vars : AgentLabelActionTo<Var> = agent_label_map(
        &labels_to_state_nums,
        |agent_index, _, _|{
            let vars = make_n_variables(&mut solver, centralized_shield.action_space[agent_index] as usize);
            solver.add(&vars);
            vars
        }
    );

    for (_, state) in centralized_shield.shield_states.iter(){
        let safe_actions = FnvHashSet::from_iter(state.actions.clone().into_iter());
        for action in centralized_shield.action_space.iter().map(|i| (0..(*i))).multi_cartesian_product(){
            if !safe_actions.contains(&action){
                let relevant_vars: Vec<Var> = zip(state.observations.iter(), action)
                    .enumerate()
                    .flat_map(|(agent_num, (indiv_obs_set, indiv_action))| {
                        indiv_obs_set.iter().map(move |indiv_obs| (agent_num, indiv_obs, indiv_action))
                    })
                    .map(|(agent_num, indiv_obs, indiv_action)|{
                        agent_label_action_vars[agent_num][indiv_obs][indiv_action as usize]
                    }).map(|var| !var).collect();
                solver.add(&relevant_vars)
            }
        }
    }

    solver.sat().map(|solution|{
        let mut dec_shield: AgentLabelActionTo<bool> = sat_solution_to_shield_naive(&solution, &agent_label_action_vars);
        expand_available_actions(&mut dec_shield, &centralized_shield, &labels_to_state_nums);
        dec_shield
    })
}