#!/bin/bash -l
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=20
#SBATCH --gres=gpu:0
#SBATCH --mem=4G
#SBATCH --time=24:00:00
#SBATCH --job-name=Flashlight
#SBATCH --partition=short
#SBATCH --output=/work/[lab_group]/[user]/centralized_verification/out5
#SBATCH --array=0-255

sleep $[ ( $RANDOM % 10 )  + 1 ]s
cd ~/code/centralized_verification || exit
module load anaconda3
# module load cuda/11.4
conda activate centralized_verification
CSV_NAME="2023_04_25_NearbyObsRecurrent2MoreSeeds"
mkdir "/work/[lab_group]/[user]/centralized_verification/output/$CSV_NAME"
OUTPUT_FILE=/work/[lab_group]/[user]/centralized_verification/output/$CSV_NAME/$SLURM_ARRAY_TASK_ID.out
PYTHONPATH=. python experiments/parallel/q_learning_2.py --node-idx $SLURM_ARRAY_TASK_ID --threads-per-node 5 parallel_configs/$CSV_NAME.csv > "$OUTPUT_FILE" 2>&1