#!/bin/bash -l

set -e

echo "${1}.smv"

../NuSMV/NuSMV/build/bin/NuSMV -source "nusmv_batch_source" "${1}.smv"
mv smv_output.tmp "${1}.csv"

conda run -n CentralizedVerification python centralized_verification/shields/partial_obs/smv_shield_loader.py "$1"

echo "Starting SAT Solver"
shield_sat/target/release/shield_sat -m sat "$1"
mv "${1}.shield_pobs_dec" "${1}_sat.shield_pobs_dec"

shield_sat/target/release/shield_sat -m naive "$1"
mv "${1}.shield_pobs_dec" "${1}_naive.shield_pobs_dec"
