import abc
import csv

import wandb

from centralized_verification.paths import WANDB_DIR


class ParallelExperiment(abc.ABC):
    @abc.abstractmethod
    def run_at_index(self, index: int):
        pass


class CSVParallelExperiment(ParallelExperiment, abc.ABC):
    def __init__(self, filename: str, func, project_name: str, tags=None):
        if tags is None:
            tags = []
        with open(filename, "r") as file:
            reader = csv.DictReader(file)
            self.params = list(reader)

        self.func = func
        self.tags = [t[-64:] for t in tags]
        self.filename = filename
        self.project_name = project_name

    def run_at_index(self, index: int):
        if index < len(self.params):
            wandb.init(config=self.params[index],
                       project=self.project_name, tags=self.tags, dir=WANDB_DIR)
            self.func(self.params[index])
            wandb.finish()
