import random

import numpy as np
import torch


def is_true(bool_ish):
    return bool_ish in (True, "1", 1, "True", "TRUE", "T", "Yes", "Y")


def set_all_seeds(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.random.manual_seed(seed)


def update_all_func(funcs, params, kwparams=None):
    if kwparams is None:
        kwparams = {}
    if funcs is None:
        return {}

    result = {}
    for param_func in funcs:
        result.update(param_func(*params, **kwparams))

    return result


def max_steps_and_episodes(params):
    max_total_steps = params.get("max_total_steps")
    if max_total_steps is not None:
        max_total_steps = int(max_total_steps)
    max_num_episodes = params.get("max_num_episodes")
    if max_num_episodes is not None:
        max_num_episodes = int(max_num_episodes)

    return max_total_steps, max_num_episodes
