from experiments.analysis.utils.format import create_table_from_run_set, create_full_table, create_diag_table
from experiments.analysis.utils.particle import change_shield_name


def run_table(run_set):
    df = create_table_from_run_set(run_set, {
        "map_name": "grid_world_map_name",
    }, True, ["map_name"])

    df_full = create_full_table(df, {"map_name": "Map Name"})
    df_diag = create_diag_table(df, {"map_name": "Map Name"}, True)

    return df_full, df_diag


def run_table_no_separate_eval(run_set):
    df = create_table_from_run_set(run_set, {
        "map_name": "grid_world_map_name",
    }, False, ["map_name"])

    df_diag = create_diag_table(df, {"map_name": "Map Name"}, False)

    return df_diag


def run_table_gridworld_1a(run_set):
    df = create_table_from_run_set(run_set, {
        "map_name": "grid_world_map_name",
        "shield_specification": "shield_specification",
        "eval_shield_specification": "evaluation_shield_specification"
    }, True, ["map_name"], pregroup_hook=lambda d:
    change_shield_name("eval_shield", "eval_shield_specification",
                       change_shield_name("shield", "shield_specification", d)))

    df_full = create_full_table(df, {"map_name": "Map Name"})
    df_diag = create_diag_table(df, {"map_name": "Map Name"}, True)

    return df_full, df_diag


def run_table_experiments_2(run_set):
    df = create_table_from_run_set(run_set, {
        "map_name": "grid_world_map_name",
        "shield_specification": "shield_specification"
    }, False, ["map_name"], primary_metric_name="test/episode_discounted_rewards_0",
                                   pregroup_hook=lambda d: change_shield_name("shield", "shield_specification", d))

    df_diag = create_diag_table(df, {"map_name": "Map Name"}, False)

    return df_diag
