import abc
from typing import List, Optional

import numpy as np


class ViolationSpecification(abc.ABC):
    @abc.abstractmethod
    def agent_nums(self) -> List[int]:
        pass

    @abc.abstractmethod
    def violates_spec(self, state, action) -> bool:
        pass

    @abc.abstractmethod
    def extract_state_from_obs(self, obs, agent_num) -> Optional[np.ndarray]:
        """
        Given an agent's observation, get the substate pertaining to just this specification,
        or None if the observation doesn't contain enough information
        (in which case, the specification cannot be violated by any action this agent will take)
        """
        pass
