from typing import NamedTuple, List, Dict, Tuple, Set, Union

label_value_type = Union[int, bool, str]
agent_label_step_type = Tuple[label_value_type, ...]
label_step_type = Tuple[agent_label_step_type, ...]
agent_shield_state_type = Tuple[agent_label_step_type, ...]
shield_state_type = Tuple[label_step_type, ...]


class PobsLabelShieldSpec(NamedTuple):
    label_names: List[List[str]]
    history_len: int
    allowed_actions: List[Dict[agent_shield_state_type, Set[int]]]


def load_agent_shield_spec(agent_label_list):
    output_dict = {}
    for label_info in agent_label_list:
        output_dict[tuple(tuple(lb) for lb in label_info["label"])] = set(label_info["actions"])

    return output_dict


def pobs_label_shield_spec_from_json(json_dict):
    return PobsLabelShieldSpec(
        label_names=json_dict["obs_names"],
        history_len=json_dict["history_len"],
        allowed_actions=[load_agent_shield_spec(a) for a in json_dict["safe_actions"]]
    )
