jupyter nbconvert --to python --RegexRemovePreprocessor.patterns="^%" superteleop.ipynb

num=1
while getopts "dhn:" opt; do
  case ${opt} in
    d )
    #   echo "Running in debug mode."
      debug=1
      ;;
    h )
    #   echo "Running in human mode."
      human=1
      ;;
    n )
        # echo "Running $OPTARG times"
        num=$OPTARG
        ;;
    \? )
      echo "Usage: cmd [-d] [-h]"
      ;;
  esac
done

for i in $(seq 1 $num)
do
    echo $i $(date +%H:%M:%S_%m%d)
    if [ -z "$human" ] && [ -z "$debug" ]
    then
        echo "Running in normal mode."
        python superteleop.py
    elif [ -n "$human" ] && [ -z "$debug" ]
    then
        echo "Running in human mode."
        python superteleop.py --human
    elif [ -n "$human" ] && [ -n "$debug" ]
    then
        echo "Running in human debug mode."
        python superteleop.py --human --debug
    elif [ -z "$human" ] && [ -n "$debug" ]
    then
        echo "Running in debug mode."
        python superteleop.py --debug
    fi
done