echo "Converting notebook to python fastrl.py"
jupyter nbconvert --to python --RegexRemovePreprocessor.patterns="^%" fastrl.ipynb

num=1
while getopts "dhn:" opt; do
  case ${opt} in
    d )
    #   echo "Running in debug mode."
      debug=1
      ;;
    h )
    #   echo "Running in human mode."
      human=1
      ;;
    n )
        # echo "Running $OPTARG times"
        num=$OPTARG
        ;;
    \? )
      echo "Usage: cmd [-d] [-h]"
      ;;
  esac
done

for i in $(seq 1 $num)
do
    echo $i $(date +%H:%M:%S_%m%d)
    if [ -z "$human" ] && [ -z "$debug" ]
    then
        echo "Running in normal mode."
        python fastrl.py
    elif [ -n "$human" ] && [ -z "$debug" ]
    then
        echo "Running in human mode."
        python fastrl.py --human
    elif [ -n "$human" ] && [ -n "$debug" ]
    then
        echo "Running in human debug mode."
        python fastrl.py --human --debug
    elif [ -z "$human" ] && [ -n "$debug" ]
    then
        echo "Running in debug mode."
        python fastrl.py --debug
    fi
done