
#!/bin/bash

# https://stackoverflow.com/questions/53422407/different-cuda-versions-shown-by-nvcc-and-nvidia-smi

# Function to check if a command exists
command_exists() {
    type "$1" &> /dev/null
}

echo "Checking CUDA Version on the System..."

# Check and print the system's CUDA version. This is runtime version you'll actually use.
if command_exists nvcc; then
    nvcc --version | grep "release"
else
    echo "CUDA not installed or nvcc not in PATH."
fi

# Check and print the CUDA driver version using nvidia-smi. This is the GPU driver and is telling you UP TO what version of the runtime you can use.
if command_exists nvidia-smi; then
    echo "CUDA Driver Version:"
    nvidia-smi | grep "CUDA Version"
else
    echo "nvidia-smi not found. Unable to determine CUDA Driver Version."
fi

echo
echo "Checking PyTorch and its Compatible CUDA Version..."

# Use Python to check PyTorch version and its compatible CUDA version
python -c 'import torch; print(f"PyTorch Version: {torch.__version__}"); print(f"CUDA Version Compatible with PyTorch: {torch.version.cuda}")'

echo
echo "For a compatible PyTorch version, ensure that the PyTorch CUDA version matches the system's CUDA version."
echo "If they don't match, consider installing a different PyTorch version using pip or conda that is compatible with your CUDA version."
