import sys

# Function to recursively sum the size of keys and values
def deep_getsizeof(o, ids=set()):
    """ Find the memory footprint of a Python object

    This is a recursive function that drills down into the contents of objects and sums their sizes.
    It handles some primitive types, but not all.
    """
    if id(o) in ids:
        return 0

    r = sys.getsizeof(o)
    ids.add(id(o))

    if isinstance(o, str):
        return r

    if isinstance(o, dict):
        return r + sum(deep_getsizeof(k, ids) + deep_getsizeof(v, ids) for k, v in o.items())

    if isinstance(o, (list, tuple, set, frozenset)):
        return r + sum(deep_getsizeof(i, ids) for i in o)
    
    # Add more types here if necessary

    return r
