#!/bin/bash

if [ -z "$envs" ];
then
  envs=(HalfCheetah-v4 Ant-v4 Hopper-v4 Walker2d-v4 Swimmer-v4)
fi

if [ -z "$seeds" ];
then
  seeds=(1 2 3 4 5 6 7 8 9 10)
fi

process_ids=(1 2 3 4 5 6)
# N trials per process, 500 trials takes ~2 minutes
n_trials=10000
# Timeout of 10 minutes
timeout=600
pop_size=30
n_eval_episodes=1

# No sensor noise
for env_id in ${envs[*]}; do
  for seed in ${seeds[*]}; do
    for process_id in ${process_ids[*]}; do
      tmux new-session -d "JAX_PLATFORMS=cpu OMP_NUM_THREADS=1 python -m open_loop.optimize --env $env_id --sampler cmaes \
        --sample-coupling -f logs/open_loop/${env_id}_${seed}/${process_id}.monitor.csv \
        --storage logs/open_loop/${env_id}_${seed}/storage.log -name $env_id \
        --n-trials $n_trials --timeout $timeout --pop-size ${pop_size} --n-eval-episodes ${n_eval_episodes}"
      sleep 0.5
    done

    JAX_PLATFORMS=cpu OMP_NUM_THREADS=1 python -m open_loop.optimize --env $env_id --sampler cmaes \
      --sample-coupling -f logs/open_loop/${env_id}_${seed}/0.monitor.csv \
      --storage logs/open_loop/${env_id}_${seed}/storage.log -name $env_id \
      --n-trials $n_trials --timeout $timeout --pop-size ${pop_size} --n-eval-episodes ${n_eval_episodes}

    # Print best trial
    # optuna best-trial --storage logs/open_loop/Hopper-v4_1/storage.log \
    # --study-name Hopper-v4 -f yaml
  done
done
