#!/bin/bash
env_seed=3831217417
n_eval_episodes=50

if [ -z "$envs" ];
then
  envs=(HalfCheetah-v4 Ant-v4 Hopper-v4 Walker2d-v4 Swimmer-v4)
fi

if [ -z "$seeds" ];
then
  # seeds=(1 2 3 4 5 6 7 8 9 10)
  seeds=(10)
fi

for env_id in ${envs[*]}; do
  for seed in ${seeds[*]}; do
    mkdir -p logs/logs/open_loop_robustness/${env_id}_${seed}
    echo "==== logs/open_loop/${env_id}_${seed} ===="
    JAX_PLATFORMS=cpu OMP_NUM_THREADS=1 python -m open_loop.run --env $env_id --seed $seed \
    -n $n_eval_episodes --seed ${env_seed} -o logs/logs/open_loop_robustness/${env_id}_${seed}/evaluations.npz \
    --storage logs/logs/open_loop/${env_id}_${seed}/storage.log \
    --study-name ${env_id} --apply-external-force
    echo -e "===========================================\n"
  done
done
