# Open Loop Control for MuJoCo Locomotion Tasks


## Install

Python 3.8+ recommended (but should work from python 3.7 to 3.11)
In a conda env:
```
pip install -r requirements.txt
```

Check and reformat code:
```
make commit-checks
```

## Run

Run the code (Swimmer-v4):
```
python -m open_loop.run --env Swimmer-v4
```

with rendering (use [TAB] to select the correct camera):
```
python -m open_loop.run --render
```

```
python -m open_loop.run --env Ant-v4
```

```
python -m open_loop.run --env HalfCheetah-v4
```

```
python -m open_loop.run --env Hopper-v4
```


```
python -m open_loop.run --env Walker2d-v4
```

## Optimize

```
OMP_NUM_THREADS=1 python -m open_loop.optimize --env Swimmer-v4 --sampler cmaes --sample-coupling
```

with a database (journal or sqlite: `sqlite:///logs/studies.db`):
```
python -m open_loop.optimize --env Swimmer-v4 --sampler cmaes -name swimmer --storage logs/studies.log
```

Note: you can launch multiple processes in different terminal using the same command to parallelize the optimization.

and visualize study with Optuna dashboard:
```
optuna-dashboard logs/studies.log
```


Ant optim:
```
OMP_NUM_THREADS=1 python -m open_loop.optimize --env Ant-v4 --sampler cmaes -name ant_coupling --storage logs/ant.log --sample-coupling --pop-size 60
```

Note: use `scripts/run.sh` to reproduce the experiments from the paper (1M timesteps, using a single process).

## Plots

```
python open_loop/plots/plot_res.py -a open_loop -e Ant-v4 HalfCheetah-v4 Hopper-v4 Walker2d-v4 Swimmer-v4 -f logs
```
