#!/bin/bash

# 5e5 steps, around 50 episodes
n_eval_steps=50000
# Seed for the first episode
seed=3831217417
algos=(sac ppo ddpg ars)
# algos=(ars)
envs=(HalfCheetah-v4 Ant-v4 Hopper-v4 Walker2d-v4 Swimmer-v4)
# envs=(HalfCheetah-v4)

export TF_CPP_MIN_LOG_LEVEL=3

# Force impulse 5N with proba=0.05
for env_id in ${envs[*]}; do
  for algo in ${algos[*]}; do
   OMP_NUM_THREADS=1 python robustness/enjoy.py --algo $algo --env $env_id --seed $seed -f logs/ \
   --verbose 0 -n $n_eval_steps --reward-log logs/robustness/external_force/$algo/$env_id --no-render -P \
   --apply-external-force --exp-id 0
  done
done

