import conf_tmaze
import ppo_tmaze
import rpg_tmaze
import lazymcts_tmaze
import lazyalphazero_tmaze
import pgmcts_tmaze


N = 10
task_setting = [[30, 0], [100, 50]]  # [corridor_length, initial_position]
#RUN_ALGOS = {'rpg', 'mcts', 'pgmcts', 'pgmcts_adpt', 'alphazero'}
#RUN_ALGOS = {'alphazero'}
RUN_ALGOS = {'ppo'}

task_setting = [task_setting[1]]

for n in range(N):
    for corridor_length, init_position in task_setting:

        if 'ppo' in RUN_ALGOS:
            conf = eval("conf_tmaze.ppo_{}_{}".format(corridor_length, init_position))
            conf.LOG_DEFAULT_FORMAT = f"[%(levelname)1.1s PPO(len={conf.CORRIDOR_LENGTH},ini={conf.INITIAL_POSITION}):{n + 1:03d}/{N:03d} %(stack_module)s:%(stack_lineno)d] %(message)s"
            ppo_tmaze.conf = conf
            ppo_tmaze.main()

        if 'rpg' in RUN_ALGOS:
            conf = eval("conf_tmaze.rpg_{}_{}".format(corridor_length, init_position))
            conf.LOG_DEFAULT_FORMAT = f"[%(levelname)1.1s PG(len={conf.CORRIDOR_LENGTH},ini={conf.INITIAL_POSITION}):{n + 1:03d}/{N:03d} %(stack_module)s:%(stack_lineno)d] %(message)s"
            rpg_tmaze.conf = conf
            rpg_tmaze.main()

        if 'mcts' in RUN_ALGOS:
            conf = eval("conf_tmaze.mcts_{}_{}".format(corridor_length, init_position))
            conf.LOG_DEFAULT_FORMAT = f"[%(levelname)1.1s MCTS(len={conf.CORRIDOR_LENGTH},ini={conf.INITIAL_POSITION}):{n + 1:03d}/{N:03d} %(stack_module)s:%(stack_lineno)d] %(message)s"
            lazymcts_tmaze.conf = conf
            lazymcts_tmaze.main()

        if 'pgmcts' in RUN_ALGOS:
            conf = eval("conf_tmaze.pgmcts_{}_{}".format(corridor_length, init_position))
            conf.LOG_DEFAULT_FORMAT = f"[%(levelname)1.1s PG-MCTS(len={conf.CORRIDOR_LENGTH},ini={conf.INITIAL_POSITION}):{n + 1:03d}/{N:03d} %(stack_module)s:%(stack_lineno)d] %(message)s"
            pgmcts_tmaze.conf = conf
            pgmcts_tmaze.main()

        if 'pgmcts_adpt' in RUN_ALGOS:
            conf = eval("conf_tmaze.pgmcts_adpt_{}_{}".format(corridor_length, init_position))
            conf.LOG_DEFAULT_FORMAT = f"[%(levelname)1.1s PG-MCTS-adpt(len={conf.CORRIDOR_LENGTH},ini={conf.INITIAL_POSITION}):{n + 1:03d}/{N:03d} %(stack_module)s:%(stack_lineno)d] %(message)s"
            pgmcts_tmaze.conf = conf
            pgmcts_tmaze.main()

        if 'alphazero' in RUN_ALGOS:
            conf = eval("conf_tmaze.alphazero_{}_{}".format(corridor_length, init_position))
            conf.LOG_DEFAULT_FORMAT = f"[%(levelname)1.1s alphazero(len={conf.CORRIDOR_LENGTH},ini={conf.INITIAL_POSITION}):{n + 1:03d}/{N:03d} %(stack_module)s:%(stack_lineno)d] %(message)s"
            lazyalphazero_tmaze.conf = conf
            lazyalphazero_tmaze.main()
